import React, { Fragment } from "react";
import PortfolioSection from "../../components/PortfolioSection";
import { NextPage } from "next";
import { CommonPageData } from "../../common/interfaces";
import Head from "next/head";
import { translateText } from "../../common/helpers";

const Portfolio: NextPage<CommonPageData> = ({ page, locale }) => {
  const { meta } = page;

  return (
    <Fragment>
      <Head>
        <title>{translateText(locale, meta)}</title>

        <link rel="icon" href="/favicon.ico" />
      </Head>
      <PortfolioSection
        portfolio={page.items.portfolio}
        page={page}
        locale={locale}
      />
    </Fragment>
  );
};

export default Portfolio;
