import Head from "next/head";
import Image from "next/image";
import React, { Fragment } from "react";
import TopBanner from "../../components/TopBanner";
import ServiceSection from "../../components/ServiceSection";
import ShowcaseSection from "../../components/ShowcaseSection";
import CapabilitiesSection from "../../components/CapabilitiesSection";
import ClientSection from "../../components/ClientSection";
import Testimonials from "../../components/Testimonials";
import { variables } from "../../common/variables";
import { getRequest } from "../../common/API";
import { NextPage } from "next";
import { CommonPageData } from "../../common/interfaces";
import { translateText } from "../../common/helpers";

const Home: NextPage<CommonPageData> = ({ page, locale }) => {
  const {
    items: { service, capabilities, client, testimonial },
    slider,
    meta,
  } = page;

  return (
    <Fragment>
      <Head>
        <title>{translateText(locale, meta)}</title>
        <meta name="description" content="Generated by create next app" />
        <link rel="icon" href="/favicon.ico" />
      </Head>

      <TopBanner slider={slider} locale={locale} />
      <ServiceSection service={service} locale={locale} />
      <ShowcaseSection />
      <CapabilitiesSection capabilities={capabilities} locale={locale} />
      <ClientSection client={client} locale={locale} />
      <Testimonials testimonial={testimonial} locale={locale} />
    </Fragment>
  );
};

export default Home;
