import React, { Fragment } from "react";
import ContactFrom from "../../components/ContactFrom";
import ContactSection from "../../components/ContactSection";
import PageTop from "../../components/PageTop";
import Head from "next/head";
import { translateText } from "../../common/helpers";
function Contact({ page, locale }) {
  const {
    items: {
      site_title,
      site_description,
      contact_email,
      contact_phone,
      site_map,
      address,
    },

    meta,
  } = page;

  return (
    <Fragment>
      <Head>
        <title>
          {meta.title_en && meta.title_bn
            ? translateText(locale, meta)
            : translateText(locale, page)}
        </title>
        <meta name="description" content="Generated by create next app" />
        <link rel="icon" href="/favicon.ico" />
      </Head>
      <PageTop subTitle={site_title} title={site_description} />
      <ContactSection
        {...{ contact_email, contact_phone, site_map, address }}
      />

      <ContactFrom />
    </Fragment>
  );
}

export default Contact;
