import React, { Fragment, useEffect } from "react";
import { Col, Container, Row, Form, FormCheck } from "react-bootstrap";
import { HiArrowRight, HiArrowLeft } from "react-icons/hi";
import { translateText } from "../../common/helpers";
import PortfolioContactForm from "../../components/PortfolioContactForm";
import Link from "next/link";

function PortfolioSingle({ locale, portfolio }) {
  return (
    <Fragment>
      {/* -------- Sticky Nav Holder Start ------------ */}
      {/* <div className="sticky_nav d-none d-lg-block">
        <div className="sticky_nav_img">
          <img className="img_fit" src={`/images/robi-side.png`} alt="" />
        </div>

        <div className="px-4 sticky_nav_holder d-flex justify-content-between align-items-center">
          <div>
            <p className="s_title">Next Project</p>
            <h4 className="s_h_title">Robi Website</h4>
          </div>
          <div className="next_preview_btn">
            <div className="d-flex btn_position">
              <button className="circle">
                <span>
                  <HiArrowLeft />
                </span>
              </button>
              <button className="circle">
                <span>
                  <HiArrowRight />
                </span>
              </button>
            </div>
          </div>
        </div>
      </div> */}
      {/* -------- Sticky Nav Holder End ------------ */}
      <Container className="top_content px-3 px-md-2 px-xl-0">
        <Row>
          <Col
            lg={6}
            className="left_section order-2 order-lg-1 single_portfolio_left"
          >
            <p className="date_info">
              <strong>{translateText(locale, portfolio, "subtitle")}</strong>{" "}
              {/* <span>.</span> {portfolio.date} */}
            </p>
            <h2 className="h_title">{translateText(locale, portfolio)}</h2>
            <div
              dangerouslySetInnerHTML={{
                __html: translateText(locale, portfolio, "content"),
              }}
            ></div>
          </Col>
          <Col lg={6} className=" order-1 order-lg-2 mb-5">
            <img className="img_fit" src={portfolio.image} alt="" />
          </Col>
        </Row>
      </Container>
      <Container fluid={true} className="got_project py-4 py-lg-5 px-3 px-md-4">
        <Container>
          <Row>
            <Col className="px-0">
              <div className="d-md-flex justify-content-between align-items-center pb-4 pb-sm-0">
                <div className="pb-4">
                  <p className="sub_title">LET’S COLLABORATE</p>
                  <h2 className="h_title">Got a project?</h2>
                </div>
                <div>
                  <Link href="/contact-us">
                    <a className="btnStyle">
                      Contact Us
                      <span className="btnArrow">
                        <HiArrowRight />
                      </span>
                    </a>
                  </Link>
                </div>
              </div>
              <hr />
              <p className="descriptin pt-3">
                We’re <strong>a team of creatives</strong> who are excited about
                unique ideas and help fin-tech companies to{" "}
                <strong>create amazing identity</strong> by crafting top-notch
                UI/UX.
              </p>
            </Col>
          </Row>
        </Container>
      </Container>
      <Container
        fluid={true}
        className="next_project_btn_section d-lg-none px-2 py-4"
      >
        <Container>
          <Row className="px-0">
            <Col className="d-flex justify-content-between align-items-center">
              <div>
                <p className="s_title">Next Project</p>
                <h4 className="s_h_title">Robi Website</h4>
              </div>
              <div className="next_preview_btn">
                <div className="d-flex btn_position">
                  <button className="circle">
                    <span>
                      <HiArrowLeft />
                    </span>
                  </button>
                  <button className="circle">
                    <span>
                      <HiArrowRight />
                    </span>
                  </button>
                </div>
              </div>
            </Col>
          </Row>
        </Container>
      </Container>
      <Container fluid={true} className="post_comment pt-5 pt-lg-0  pb-5">
        <Container className="px-0 single_portfolio_contact">
          <Row>
            <Col>
              <h4 className="s_h_title">Send a message</h4>
              <p>
                Your email address will not be published. Required fields are
                marked *
              </p>
              <PortfolioContactForm />
            </Col>
          </Row>
        </Container>
      </Container>
    </Fragment>
  );
}

export default PortfolioSingle;
