import { AxiosResponse } from "axios";
import React, { useEffect } from "react";
import { getRequest } from "../common/API";
import variables from "../common/variables";
import useSiteSetting from "./../common/hooks/useSiteSetting";
import {
  Home,
  About,
  Contact,
  Services,
  Portfolio,
  Default,
} from "../templates";
import { GetStaticProps, InferGetStaticPropsType } from "next";
import { useRouter } from "next/router";

const FrontPage: React.FC<any> = ({ page_data, site_setting }) => {
  const router = useRouter();
  const { locale } = router;
  const [setting, setSetting] = useSiteSetting();
  useEffect(() => {
    setSetting(site_setting);
    return () => {};
  }, [setSetting, site_setting]);
  const { data: page } = page_data;

  let content = null;
  switch (page.template_name) {
    case "Default":
      content = <Default page={page} locale={locale} />;
      break;
    case "Home":
      content = <Home page={page} locale={locale} />;
      break;
    case "About Us":
      content = <About page={page} locale={locale} />;
      break;
    case "Contact Us":
      content = <Contact page={page} locale={locale} />;
      break;
    case "Service":
      content = <Services page={page} locale={locale} />;
      break;
    case "Portfolio":
      content = <Portfolio page={page} locale={locale} />;
      break;
    default:
      content = <Default page={page} locale={locale} />;
  }
  return content;
};

export const getStaticProps: GetStaticProps = async () => {
  let page_data: AxiosResponse<any, any> | undefined;
  let site_setting;
  try {
    page_data = await getRequest(variables.apiUrls.getPageData + "home");
    site_setting = await getRequest(variables.apiUrls.getSiteSetting);
    if (page_data && page_data.data.status !== "SUCCESS") {
      return {
        notFound: true,
      };
    }
  } catch (err) {
    throw err;
  }

  return {
    props: {
      page_data: page_data.data,
      site_setting: site_setting.data.data,
    },
    revalidate: 180,
  };
};

export default FrontPage;
