import "../node_modules/bootstrap/dist/css/bootstrap.min.css";
import "../asset/scss/style.scss";
import Layout from "../components/Layout";
import type { AppProps } from "next/app";
import { UiContextProvider } from "../common/contexts/UiContextProvider";
import NextNProgress from "nextjs-progressbar";
import { ThemeProvider } from "next-themes";
import { ToastContainer } from "react-toastify";
import ErrorBoundary from "../components/ErrorBoundary";
import ErrorFallback from "./../components/ErrorFallback";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";
import "react-toastify/dist/ReactToastify.css";
import config from "react-reveal/globals";

config({ ssrFadeout: true });

function MyApp({ Component, pageProps }: AppProps) {
  return (
    <ThemeProvider enableSystem={false}>
      <UiContextProvider>
        <ErrorBoundary FallbackComponent={ErrorFallback}>
          <Layout>
            <NextNProgress color="#d90a2c" />
            <Component {...pageProps} />
          </Layout>
        </ErrorBoundary>
        <ToastContainer
          position="bottom-center"
          autoClose={5000}
          hideProgressBar={true}
          className="custom_toast"
        />
      </UiContextProvider>
    </ThemeProvider>
  );
}

export default MyApp;
