import React, { useEffect, Fragment } from "react";
import { getRequest } from "../common/API";
import variables from "../common/variables";
import { Col, Container, Row, Button } from "react-bootstrap";
import { MdOutlineError } from "react-icons/md";
import Link from "next/link";
import useSiteSetting from "./../common/hooks/useSiteSetting";
function Error(props) {
  const [setting, setSetting] = useSiteSetting();
  const { site_setting } = props;
  useEffect(() => {
    setSetting(site_setting);
    return () => {};
  }, [setSetting, site_setting]);
  return (
    <Fragment>
      <Container className="error_section flex_center text-center section_margin">
        <Row>
          <Col>
            <h1 className="title">
              4
              <span>
                <MdOutlineError />
              </span>
              4
            </h1>
            <h2 className="sub_title">Oops! Page not found.</h2>
            <p>We can't find the page you're looking for.</p>
            <Link href="/">
              <Button className="btnStyle">Go back to home</Button>
            </Link>
          </Col>
        </Row>
      </Container>
    </Fragment>
  );
}

export const getStaticProps = async (ctx) => {
  const site_setting = await getRequest(variables.apiUrls.getSiteSetting);
  return {
    props: {
      site_setting: site_setting.data.data,
    },
    revalidate: 180,
  };
};

export default Error;
