import React, { Fragment, useEffect, useState } from "react";
import { Container, Button, Nav, Navbar, NavDropdown } from "react-bootstrap";
import { NavLink } from "./NavLink";
import Image from "next/image";
import brandlogo from "../asset/images/Swt_logo_black.png";
import brandlogoWhite from "../asset/images/Swt_logo_white.png";
import { HiMenuAlt4 } from "react-icons/hi";
import HamburgerMenu from "./HamburgerMenu";
import LocaleSwitcher from "./LocaleSwitcher";
import { useTheme } from "next-themes";
import { useUiState } from "../common/contexts/UiContextProvider";
import { useUiStateModifier } from "../common/contexts/UiContextProvider";
import { useRouter } from "next/router";
import { IoAddOutline } from "react-icons/io5";
import NavItem from "./NavItem";

function TopNavigation(props) {
  const router = useRouter();
  const { locale } = router;
  const { setFullScreenMenuOpen } = useUiStateModifier();
  const [menus, setMenus] = useState([]);
  const { theme, setTheme } = useTheme();
  const [UiState, setUiState] = useUiState();
  function HamburgerOpen() {
    if (UiState.fullScreenMenuOpen) {
      setFullScreenMenuOpen(false);
    } else {
      setFullScreenMenuOpen(true);
    }
  }
  useEffect(() => {
    setMenus(UiState.setting.menus.main);
    return () => {};
  }, [UiState]);

  return (
    <Fragment>
      <Navbar
        className="top_navigation"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_black"}'
      >
        <Container fluid={true} className="mx-1 mx-xl-4 mx-sm-3">
          <Navbar.Brand className="brand_logo">
            <Button className="hamburger_btn" onClick={HamburgerOpen}>
              <HiMenuAlt4 className="hamburger_btn_icon" />
            </Button>
            <NavLink exact to="/">
              {theme == "light" || !theme ? (
                <img
                  className="navLogoImage"
                  src={UiState.setting.site_logo_dark || brandlogo.src}
                />
              ) : (
                <img
                  className="navLogoImage"
                  src={UiState.setting.site_logo_light || brandlogoWhite.src}
                />
              )}
            </NavLink>
          </Navbar.Brand>

          <Nav className="ml-auto menu d-none d-lg-flex">
            {menus.map((item, idx) => {
              return (
                <NavItem
                  locale={locale}
                  menuItem={item}
                  key={item.slug}
                  serial={idx + 1}
                />
              );
            })}

            {/* --------- Dropdown Menu Start ---------- */}
            {/* <NavLink exact to="/" className="navItem nav_dropdown">
              Dropdown
              <span className="number_text">01</span>
              <div className="dropdown_section dropdown_menu">
                <NavLink exact to="/" className="dropdown_item">
                  Dropdown1
                  <span className="add_icon">
                    <IoAddOutline />
                  </span>
                  <div className="dropdown_section sub_dropdown_menu">
                    <NavLink exact to="/" className="dropdown_sub_item">
                      Sub-Dropdown1
                    </NavLink>
                    <NavLink exact to="/" className="dropdown_sub_item">
                      Sub-Dropdown2
                    </NavLink>
                    <NavLink exact to="/" className="dropdown_sub_item">
                      Sub-Dropdown3
                    </NavLink>
                  </div>
                </NavLink>
                <NavLink exact to="/" className="dropdown_item">
                  Dropdown1
                  <span className="add_icon">
                    <IoAddOutline />
                  </span>
                </NavLink>
                <NavLink exact to="/" className="dropdown_item">
                  Dropdown1
                  <span className="add_icon">
                    <IoAddOutline />
                  </span>
                </NavLink>
              </div>
            </NavLink> */}

            {/* --------- Dropdown Menu End ---------- */}

            <NavLink to="/contact-us" className="btnStyle">
              Let's Talk
            </NavLink>
          </Nav>
          <NavLink to="/contact-us" className="btnStyle d-lg-none">
            Let's Talk
          </NavLink>
        </Container>
        {/* <LocaleSwitcher /> */}
      </Navbar>
      {UiState.fullScreenMenuOpen ? (
        <HamburgerMenu handleClose={HamburgerOpen} locale={locale} />
      ) : null}
    </Fragment>
  );
}

export default TopNavigation;
