import React, { Fragment, useState } from "react";
import { Col, Container, Row } from "react-bootstrap";
import { IoMdPlay } from "react-icons/io";
import { Modal } from "react-bootstrap";
import { TopBannerProps } from "../common/interfaces";
import { translateText } from "../common/helpers";
import Link from "next/link";

const TopBanner: React.FC<TopBannerProps> = ({ slider, locale }) => {
  const [isOpen, setIsOpen] = useState(false);

  return (
    <Fragment>
      <Container
        className="top_banner"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_black"}'
      >
        <Row>
          <Col lg={7} sm={12}>
            <div
              className="left_content d-none d-sm-block"
              style={{
                backgroundImage: `url("${slider[0]?.image}")`,
              }}
            ></div>
          </Col>
          <Col lg={5} sm={12}>
            <div className="red_circle">
              <div className="overlay_content">
                <div className="video_play_btn">
                  <span
                    className="triangle_shep"
                    onClick={() => setIsOpen(true)}
                  >
                    <IoMdPlay />
                  </span>
                </div>
                <h1 className="title">
                  {slider[0] && translateText(locale, slider[0])}
                </h1>
                <p className="sub_title">
                  {slider[0] && translateText(locale, slider[0], "sub_title")}
                </p>
                <Link href={`${slider[0].action_url}`}>
                  <a className="btnStyle">Get Started</a>
                </Link>
              </div>
            </div>
          </Col>
        </Row>
      </Container>
      <Modal
        show={isOpen}
        fullscreen={true}
        onHide={() => setIsOpen(false)}
        className="banner_modal"
      >
        <Modal.Header closeButton closeVariant="white"></Modal.Header>
        <Modal.Body>
          <div className="video_content">
            <iframe
              width="1246"
              height="701"
              src="https://www.youtube.com/embed/xpGHmOocgC8?autoplay=1"
              title="YouTube video player"
              frameborder="0"
              allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
              allowFullScreen="allowFullScreen"
            ></iframe>
          </div>
        </Modal.Body>
      </Modal>
    </Fragment>
  );
};

export default TopBanner;
