import React, { useRef, useState } from "react";
import { Col } from "react-bootstrap";
import Slider from "react-slick";
import { HiArrowLeft, HiArrowRight } from "react-icons/hi";
import { translateText } from "../common/helpers";

interface TestimonialSliderProps {
  data: any;
  locale: string | undefined;
}

const TestimonialSlider: React.FC<TestimonialSliderProps> = ({
  data,
  locale,
}) => {
  const [currentSlide, setCurrentSlide] = useState(1);
  const settings = {
    speed: 500,
    slidesToShow: 1,
    slidesToScroll: 1,
    arrows: false,
    autoplay: true,
  };

  const sliderContainer = useRef<Slider>(null);

  const next = () => {
    if (sliderContainer && sliderContainer.current) {
      sliderContainer.current.slickNext();
    }
  };
  const previous = () => {
    if (sliderContainer && sliderContainer.current) {
      sliderContainer.current.slickPrev();
    }
  };

  const afterChangeHandler = (currentSlide: any) => {
    setCurrentSlide(currentSlide + 1);
  };
  return (
    <Col xl={9} className="client_review_content">
      <Slider
        {...settings}
        /* @ts-ignore */
        ref={(slider) => (sliderContainer.current = slider)}
        afterChange={afterChangeHandler}
      >
        {data &&
          data.map((slide: any, index: any) => {
            return (
              <div className="client_review_info" key={index}>
                {slide.avatar && (
                  <img src={slide.avatar} alt={translateText(locale, slide)} />
                )}
                <blockquote className="messages py-3">
                  {translateText(locale, slide, "comment")}
                  <div className="signature">
                    <span>{translateText(locale, slide, "name")}</span>
                    <span>{translateText(locale, slide, "company")}</span>
                  </div>
                </blockquote>
              </div>
            );
          })}
      </Slider>
      <div className="next_preview_btn">
        <div className="d-flex btn_position">
          <div className="circle" onClick={previous}>
            <span className="arrow">
              <HiArrowLeft />
            </span>
          </div>

          <div className="circle" onClick={next}>
            <span className="arrow">
              <HiArrowRight />
            </span>
          </div>
        </div>
      </div>
      <div className="slider_count">
        {currentSlide} <span>{data && data.length}</span>
      </div>
    </Col>
  );
};

export default TestimonialSlider;
