import React, { useEffect, useState } from "react";
// import { useSpring, animated } from "react-spring";
import { motion, useAnimation, useMotionValue } from "framer-motion";
import { useInView } from "react-intersection-observer";
const SingleCapability = ({ capability }) => {
  const [ref, inView] = useInView();
  const controls = useAnimation();
  const percentage = useMotionValue(capability.value);
  //   const styles = useSpring({ width: capability.value });
  const animateVariants = {
    visible: { width: capability.value + "%" },
    hidden: { width: 0 + "%" },
  };

  useEffect(() => {
    if (inView) {
      controls.start("visible");
    }
  }, [controls, inView]);

  // useEffect(() => {
  //   console.log(percentage.current);
  // }, [percentage]);
  return (
    <div className="bar">
      <div className="info">
        <span>{capability.name}</span>
      </div>
      <div className="progress_line web">
        <motion.span
          ref={ref}
          animate={controls}
          variants={animateVariants}
          initial="hidden"
          transition={{ duration: 1 }}
          className="percentage_bg"
        >
          <motion.span
            className="percentage_value"
            transition={{ duration: 1 }}
          >
            {percentage.current}
          </motion.span>
        </motion.span>
      </div>
    </div>
  );
};

export default SingleCapability;
