import React, { Fragment } from "react";
import { Col, Container, Row } from "react-bootstrap";
import { ServiceProps } from "../common/interfaces";
import { translateText } from "../common/helpers";
import ServiceIconSvg from "./ServiceIconSvg";
// @ts-ignore
import Fade from "react-reveal/Fade";

const ServiceSection: React.FC<ServiceProps> = ({ service, locale }) => {
  return (
    <Fragment>
      <div
        className="service_section"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_white"}'
      >
        <Container className="service_section_inner px-4 px-sm-0">
          <Row>
            <Col md={6}>
              <Fade bottom duration={1000}>
                <div className="left_section">
                  <p>WHAT WE DO</p>
                  <h2>{translateText(locale, service)}</h2>
                </div>
              </Fade>
            </Col>
            <Col md={6}>
              <div className="right_section">
                <Fade bottom duration={1000}>
                  <p>{translateText(locale, service, "content")}</p>
                  <Row className="service_catagory">
                    {service.items &&
                      service.items.length > 0 &&
                      service.items.map((s, i) => {
                        return (
                          <Col md={6} key={i}>
                            <div className="uxDesign">
                              {s.icon.includes(".svg") ? (
                                <ServiceIconSvg
                                  iconurl={s.icon}
                                  className="icon"
                                />
                              ) : (
                                <img src={s.icon} className="icon"></img>
                              )}

                              <h5 className="title">
                                {translateText(locale, s)}
                              </h5>
                              <p className="description">
                                {translateText(locale, s, "description")}
                              </p>
                            </div>
                          </Col>
                        );
                      })}
                  </Row>
                </Fade>
              </div>
            </Col>
          </Row>
        </Container>
      </div>
    </Fragment>
  );
};

export default ServiceSection;
