import React, { Fragment, useState } from "react";
import { Col, Container, Row } from "react-bootstrap";
import { translateText } from "../common/helpers";
import ClentBrandListColor from "./ClentBrandListColor";
import Fade from "react-reveal/Fade";
import Zoom from "react-reveal/Fade";

function SatisfiedClients({ client, locale }) {
  if (!client) {
    return null;
  }
  return (
    <Fragment>
      <Container
        className="satisfied_clients py-5"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_black"}'
      >
        <Row>
          <Col xl={3} lg={4} md={4} className="left_section">
            <Fade bottom duration={1000}>
              <p className="sub_title">{translateText(locale, client)}</p>
              <h2 className="title">
                {translateText(locale, client, "sub_title")}
              </h2>
            </Fade>
          </Col>
          <Col xl={9} lg={8} md={8} className="brand_logo">
            <Row>
              <Col>
                <div className="client_list flex-wrap d-flex justify-content-between align-items-center about_client">
                  {client.items.map((singleClient, k) => {
                    return (
                      <Zoom key={k} delay={500 + k}>
                        <div className="client_logo">
                          <a
                            href={singleClient.website}
                            target="_blank"
                            rel="noreferrer"
                          >
                            <img
                              src={singleClient.logo}
                              alt={translateText(locale, singleClient)}
                            />
                          </a>
                        </div>
                      </Zoom>
                    );
                  })}
                </div>
              </Col>
            </Row>
          </Col>
        </Row>
      </Container>
    </Fragment>
  );
}

export default SatisfiedClients;
