import React, { Fragment } from "react";
import { Button, Col, Container, Row } from "react-bootstrap";
import { HiArrowRight, HiArrowLeft } from "react-icons/hi";
import Link from "next/link";
import Fade from "react-reveal/Fade";

function QuickDiscussion(props) {
  return (
    <Fragment>
      <div className="quick_discussion_section">
        <Container
          className="quick_discussion_inner px-4"
          data-immerser-layer
          data-immerser-layer-config='{"left_scroll": "left_scroll_color_white"}'
        >
          <Row>
            <Col md={6}>
              <Fade bottom duration={1000}>
                <p className="s_title">Contact with us</p>
                <h2 className="h_title">Let's have a quick discussion</h2>
              </Fade>
            </Col>
            <Col
              md={6}
              className="d-flex justify-content-sm-end align-items-center align-items-sm-start my-sm-0 my-3"
            >
              <Fade bottom duration={1000}>
                <Link href="/contact-us">
                  <a className="btnStyle">
                    Get a Quote
                    <span className="btnArrow">
                      <HiArrowRight />
                    </span>
                  </a>
                </Link>
              </Fade>
            </Col>
          </Row>
        </Container>
      </div>
    </Fragment>
  );
}

export default QuickDiscussion;
