import React, { Fragment, useState, useEffect, useRef } from "react";
import { Button, Container } from "react-bootstrap";
import { GoSearch } from "react-icons/go";
import Immerser from "immerser";
import SearchPage from "./SearchPage";
import { useTheme } from "next-themes";
import { useRouter } from "next/router";
import { useUiState } from "../common/contexts/UiContextProvider";
function OverlayContentLeft(props) {
  const [UiState, setUiState] = useUiState();
  const [openSearch, setOpenSearch] = useState(false);
  const { theme, setTheme } = useTheme();

  const ref = useRef(null);
  function SearchPageOpen(e) {
    e && e.preventDefault();
    setOpenSearch(!openSearch);
  }
  useEffect(() => {
    setUiState((prev) => {
      return { ...prev, overlayLeftRef: ref };
    });

    return () => {};
  }, [ref, setUiState]);

  return (
    <Fragment>
      <Container
        fluid={true}
        className="overlay_section_left d-none d-lg-block"
      >
        <div className="d-flex flex-column align-items-center">
          {theme == "light" ? (
            <Button
              className="dark_light_btn"
              onClick={() => {
                setTheme("dark");
              }}
            >
              <span className="dark active">Dark</span>
              <span className="light ">Light</span>
            </Button>
          ) : (
            <Button
              className="dark_light_btn "
              onClick={() => {
                setTheme("light");
              }}
            >
              <span className="dark ">Dark</span>
              <span className="light active">Light</span>
            </Button>
          )}

          <div
            className="scroll_btn toTop"
            data-immerser
            onClick={() => window.scrollTo(0, 0)}
            ref={ref}
          >
            <p data-immerser-solid="left_scroll">Scroll to top</p>
          </div>
          {/* <Button className="search_btn" onClick={SearchPageOpen}>
            <span>
              <GoSearch />
            </span>
          </Button> */}
        </div>
      </Container>
      {/* {openSearch ? <SearchPage handleClose={SearchPageOpen} /> : null} */}
    </Fragment>
  );
}

export default OverlayContentLeft;
