import { useRouter } from "next/router";
import Link from "next/link";
import PropTypes from "prop-types";

NavLink.propTypes = {
  to: PropTypes.string.isRequired,
  exact: PropTypes.bool,
};

NavLink.defaultProps = {
  exact: false,
};

function NavLink({ to = "#", exact, children, ...props }) {
  const { pathname } = useRouter();
  const isActive = exact ? pathname === to : pathname.startsWith(to);

  if (isActive) {
    props.className += " active";
  }

  return (
    <>
      {to.includes("http") ? (
        <a href={to} {...props} target="_blank" rel="noreferrer">
          {children}
        </a>
      ) : (
        <Link href={(to.startsWith("/") ? to : "/" + to) || ""}>
          <a {...props}>{children}</a>
        </Link>
      )}
    </>
  );
}

export { NavLink };
