import React from "react";
import { NavLink } from "./NavLink";
import { translateText } from "./../common/helpers";
import { NavDropdown } from "react-bootstrap";
import { IoAddOutline } from "react-icons/io5";
const NavItem = ({ locale, menuItem, serial, sub = false }) => {
  const { type, slug, children } = menuItem;
  return children.length > 0 ? (
    <NavLink
      exact
      to={menuItem.slug}
      className="navItem nav_dropdown dropdown_item"
    >
      {translateText(locale, menuItem)}
      <span className="number_text">0{serial}</span>
      <span className="add_icon">
        <IoAddOutline />
      </span>
      <div
        className={`dropdown_section ${
          sub ? "sub_dropdown_menu" : "dropdown_menu"
        }`}
      >
        {children.map((childMenuItem, idx) => {
          return (
            <NavItem
              locale={locale}
              menuItem={childMenuItem}
              key={childMenuItem.slug}
              serial={idx + 1}
              sub={true}
            />
          );
        })}
      </div>
    </NavLink>
  ) : (
    <NavLink
      exact
      className={`${sub ? "dropdown_sub_item" : "navItem"}`}
      to={menuItem.slug}
    >
      {translateText(locale, menuItem)}
      <span className="number_text">0{serial}</span>
    </NavLink>
  );
};

export default NavItem;
