import Link from "next/link";
import { useRouter } from "next/router";
import React from "react";
const LocaleSwitcher: React.FC = () => {
  const router = useRouter();
  const { locales, locale: activeLocale } = router;
  const otherLocales =
    locales && locales.filter((locale) => locale !== activeLocale);

  return (
    <div>
      <ul>
        {otherLocales &&
          otherLocales.map((locale) => {
            const { pathname, query, asPath } = router;
            return (
              <li key={locale}>
                <Link href={{ pathname, query }} as={asPath} locale={locale}>
                  <a>{locale === "bn" ? "Bangla" : "English"}</a>
                </Link>
              </li>
            );
          })}
      </ul>
    </div>
  );
};

export default LocaleSwitcher;
