import React, { Fragment } from "react";
import Iframe from "react-iframe";
import { Col, Container, Row } from "react-bootstrap";

function ContactSection({ contact_email, phone, site_map, address }) {
  return (
    <Fragment>
      <Container fluid={true} className="contact_section">
        <Container>
          <Row className="mx-2 pb-3 pb-lg-5">
            <Col sm={6} className="address_section px-4 px-lg-5 mb-5 mb-sm-0">
              <div className="section_inner">
                <h4 className="s_h_title py-3">Location</h4>
                <address
                  dangerouslySetInnerHTML={{ __html: address }}
                ></address>
                <h4 className="s_h_title py-3">General inquiries</h4>
                <p>
                  <a href={`mailto:${contact_email}`}>{contact_email}</a>
                </p>
              </div>
            </Col>
            <Col sm={6} className="title_section px-4 px-lg-5">
              <div className="section_inner">
                <h4 className="title">At Choice, you can always talk to us!</h4>
                <p>
                  Have any questions on your mind? Our entire team has
                  specialized training regularly to ensure that you’re getting
                  the best information possible. we’re here to help!
                </p>
              </div>
            </Col>
          </Row>
          <div
            className="px-2 pt-5"
            dangerouslySetInnerHTML={{ __html: site_map }}
          ></div>
        </Container>
      </Container>
    </Fragment>
  );
}

export default ContactSection;
