import React, { Fragment, useState } from "react";
import { Container } from "react-bootstrap";
import ClientBrandList from "./ClientBrandList";
import { motion } from "framer-motion";
import { translateText } from "../common/helpers";
import Zoom from "react-reveal/Zoom";
const ClientSection: React.FC = ({ client, locale }) => {
  const { items } = client;
  if (!client) {
    return null;
  }
  return (
    <Fragment>
      <Container
        fluid={true}
        className="client_section"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_white"}'
      >
        <Container className="px-0">
          <div className="client_list flex-wrap d-flex">
            {items.map((singleClient: any) => {
              return (
                <Zoom key={singleClient.website}>
                  <div className="client_logo">
                    <a
                      href={singleClient.website}
                      target="_blank"
                      rel="noreferrer"
                      className="client_logo_link"
                    >
                      <img
                        src={singleClient.logo}
                        alt={translateText(locale, singleClient)}
                        className="animated_logo"
                      />
                    </a>
                  </div>
                </Zoom>
              );
            })}
          </div>
        </Container>
      </Container>
    </Fragment>
  );
};

export default ClientSection;
