import React from "react";
import { Nav } from "react-bootstrap";
import { translateText } from "../common/helpers";
import { BreadCrumbProps } from "../common/interfaces";
import Link from "next/link";
import { NavLink } from "./NavLink";
import { useRouter } from "next/router";

const BreadCrumb: React.FC<BreadCrumbProps> = ({ breadcrumb, locale }) => {
  const router = useRouter();

  /* @ts-ignore */
  const currentPage = router.query.slug[router.query.slug.length - 1];

  return (
    <Nav className="breadcrumb_section">
      <ol className="breadcrumb bg-transparent pl-0">
        <li className="breadcrumb-item">
          <NavLink to="/">Home</NavLink>
        </li>
        {breadcrumb.length > 0 &&
          breadcrumb.map((b: any, index: any) => (
            <li className="breadcrumb-item" key={index}>
              <Link href="#">
                <a
                  className="breadcrumb_link"
                  style={{
                    pointerEvents: currentPage === b.slug ? "none" : "auto",
                    fontWeight: currentPage === b.slug ? 500 : 400,
                  }}
                >
                  {translateText(locale, b)}
                </a>
              </Link>
            </li>
          ))}
      </ol>
    </Nav>
  );
};

export default BreadCrumb;
