import React, { Fragment } from "react";
import { Col, Container, Row } from "react-bootstrap";
import aboutUsOne from "../asset/images/Softwind-Tech-Employee_1.jpg";
import aboutUsTwo from "../asset/images/Softwind-Tech-Employee_2.jpg";
import { IoKeypad } from "react-icons/io5";
import { translateText } from "./../common/helpers";
import Link from "next/link";
import Fade from "react-reveal/Fade";

const AboutApproachStats = ({ approach, statistics, locale }) => {
  return (
    <Fragment>
      <Container
        fluid={true}
        className="parallax_swt_banner d-none d-md-inline-block"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_white"}'
        style={{ backgroundImage: `url(${approach?.thumb_sd})` }}
      ></Container>
      <Container
        className="swt_approach px-3"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_black"}'
      >
        {approach && (
          <Row className="mb-5 mb-md-3">
            <Col md={4} className="approach_section">
              <Fade bottom duration={1000}>
                <p className="sub_title">{translateText(locale, approach)}</p>
                <h2 className="title">
                  {translateText(locale, approach, "subtitle")}
                </h2>
                <p className="description pb-3">
                  {translateText(locale, approach, "excerpt")}
                </p>
              </Fade>
            </Col>
            <Col md={4} className="swt_about_us_one px-2 px-lg-4 mb-4">
              <Fade bottom duration={1000}>
                <img src={approach.thumb || aboutUsOne} alt="" />
              </Fade>
            </Col>
            <Col md={4} className="swt_about_us_one px-2 px-lg-4">
              <Fade bottom duration={1000}>
                <img src={approach.banner || aboutUsTwo} alt="" />
              </Fade>
            </Col>
          </Row>
        )}
        {statistics && (
          <Fade bottom duration={1000}>
            <Row className="mb-5">
              <Col md={4} className="approach_section">
                <p className="sub_title">{translateText(locale, statistics)}</p>
                <h2 className="title mb-4">
                  {translateText(locale, statistics, "subtitle")}
                </h2>
              </Col>
              <Col
                md={8}
                className="px-4"
                dangerouslySetInnerHTML={{
                  __html: translateText(locale, statistics, "content"),
                }}
              />
            </Row>
          </Fade>
        )}
      </Container>
    </Fragment>
  );
};

export default AboutApproachStats;
