/* @ts-ignore */
import en from "../common/locales/en";
/* @ts-ignore */
import bn from "../common/locales/bn";

export const translate = (
  locale: string | undefined,
  key: any,
  params = null
) => {
  if (locale === "bn") {
    /* @ts-ignore */
    return getValue(bn, key, params);
  } else {
    /* @ts-ignore */
    return getValue(en, key, params);
  }
};

function getValue(locale: string, key: any, params = null) {
  let keys = key.split(".");
  let test = locale;
  keys.forEach((i: any) => {
    test = test[i];
  });

  // currently not needed as params will be empty always
  if (params !== null) {
    let stripped = test;
    Object.keys(params).forEach((j) => {
      stripped = stripped.replace(`{${j}}`, params[j]);
    });
    return stripped;
  } else {
    return test || key;
  }
}

export const translateText = (
  lang: string | undefined,
  item: any,
  key = "title"
) => {
  if (typeof item === "undefined" || item === null) {
    return "";
  }
  return lang === "en" ? item[key + "_en"] : item[key + "_bn"];
};

export const flatArray = (arr: any[]) => {
  const flat: any[] = [];
  arr.map((p: any) => {
    if (p.children) {
      p.children.map((cp: any) => {
        flat.push(cp);
      });
      p.children = [];
    }
    flat.push(p);
  });
  return flat;
};

export const safeParseJSON = (jsonString: string) => {
  try {
    return JSON.parse(jsonString);
  } catch (error) {
    return null;
  }
};

export async function avoidRateLimit(ms = 1000) {
  if (process.env.NODE_ENV === "production") {
    await sleep(ms);
  }
}

function sleep(ms = 1000) {
  return new Promise((res) => setTimeout(res, ms));
}
