"use strict";
exports.id = 248;
exports.ids = [248];
exports.modules = {

/***/ 5248:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "kP": () => (/* binding */ UiContextProvider),
/* harmony export */   "tN": () => (/* binding */ useUiState),
/* harmony export */   "dz": () => (/* binding */ useUiStateModifier)
/* harmony export */ });
/* unused harmony exports UiContext, defaultUiState */
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var immerser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9504);
/* harmony import */ var immerser__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(immerser__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





const UiContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)();
const defaultUiState = {
  fullScreenMenuOpen: false,
  overlayLeftRef: null,
  setting: {
    site_name: "SoftwindTech Ltd",
    site_title: "SoftwindTech is a leading digital marketing agency",
    site_description: "SoftwindTech is a leading digital marketing agency, offers holistic results driven marketing solution to businesses worldwide.",
    site_logo: "",
    menus: {
      main: [],
      footer: [],
      mobile: []
    }
  }
};

function overlayImmer() {
  try {
    const immerserInstance = new (immerser__WEBPACK_IMPORTED_MODULE_2___default())({
      // this option will be overridden by options
      // passed in data-immerser-layer-config attribute in each layer
      solidClassnameArray: [{
        left_scroll: "left_scroll_color_white"
      }],
      hasToUpdateHash: false,
      // fromViewportWidth: 1024,
      // pagerLinkActiveClassname: "pager__link--active",
      scrollAdjustThreshold: 0,
      scrollAdjustDelay: 600,

      onInit(immerser) {// callback on init
      },

      onBind(immerser) {
        var _document$querySelect;

        // callback on bind
        (_document$querySelect = document.querySelector(".scroll_btn")) === null || _document$querySelect === void 0 ? void 0 : _document$querySelect.classList.remove("toTop");
      },

      onUnbind(immerser) {
        var _document$querySelect2;

        // callback on unbind
        (_document$querySelect2 = document.querySelector(".scroll_btn")) === null || _document$querySelect2 === void 0 ? void 0 : _document$querySelect2.classList.add("toTop");
      },

      onDestroy(immerser) {// callback on destroy
      },

      onActiveLayerChange(activeIndex, immerser) {// callback on active layer change
      }

    });
    window.immerserInstance = immerserInstance;
  } catch (e) {}
}

const UiContextProvider = ({
  children
}) => {
  const {
    0: UiState,
    1: setUiState
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(defaultUiState);
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();

  const onRouteChangeDone = (url, {
    shallow
  }) => {
    overlayImmer();
    setUiState(prev => {
      return _objectSpread(_objectSpread({}, prev), {}, {
        fullScreenMenuOpen: false
      });
    });
  };

  const onRouteChangeStart = (url, {
    shallow
  }) => {
    var _window$immerserInsta;

    (_window$immerserInsta = window.immerserInstance) === null || _window$immerserInsta === void 0 ? void 0 : _window$immerserInsta.destroy();
  };

  const onRouteChangeError = (err, url, {
    shallow
  }) => {
    if (err.cancelled) {
      overlayImmer();
    }
  };

  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    router.events.on("routeChangeComplete", onRouteChangeDone);
    router.events.on("routeChangeStart", onRouteChangeStart);
    router.events.on("routeChangeError", onRouteChangeError);
    return () => {
      router.events.off("routeChangeComplete", onRouteChangeDone);
      router.events.off("routeChangeStart", onRouteChangeStart);
      router.events.off("routeChangeError", onRouteChangeError);
    };
  }, [router]);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (localStorage.getItem(`UiData`)) {
      setUiState(JSON.parse(localStorage.getItem(`UiData`)));
    }

    return () => {};
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (!window.immerserInstance) {
      overlayImmer();
    }
  }, []);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(UiContext.Provider, {
    value: [UiState, setUiState],
    children: children
  });
};
const useUiState = () => {
  const {
    0: UiState,
    1: setUiState
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(UiContext);
  return [UiState, setUiState];
};
const useUiStateModifier = () => {
  const {
    0: UiState,
    1: setUiState
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(UiContext);

  const setFullScreenMenuOpen = show => {
    setUiState(prev => {
      return _objectSpread(_objectSpread({}, prev), {}, {
        fullScreenMenuOpen: show
      });
    });
  };

  return {
    setFullScreenMenuOpen
  };
};

/***/ })

};
;